close all
clear all
% DEFINITION OF THE GEOMETRY
gd=[2;4;0;1;1;0;0;0;1;1]; %canale dritto
% MESH GENERATION
dl=decsg(gd);
[vertices,boundaries,elements]=initmesh(dl,'hmax',0.075,'hgrad',1.7);
%mesh plot
pdemesh(vertices,boundaries,elements);
axis equal

% P2 MESH
row4 = elements(4,:);
[elements,vertices,boundaries]=P1toP2mesh2D(elements,vertices,boundaries);
elements = [elements; row4];

%IMOSITION OF B.C.
boundaries(5,:)=2;
ind_sin=find( vertices(1,boundaries(2,:))==0 & vertices(1,boundaries(1,:))==0);
ind_des=find( vertices(1,boundaries(2,:))==1 & vertices(1,boundaries(1,:))==1);
boundaries(5,ind_sin)=1;
boundaries(5,ind_des)=1;

%lmax=1;

%NUMBERING
noe    = size(elements,2);          %number of elements
nov    = size(vertices,2);          %number of nodes
nov_v  = 2*nov;                     %number of dof for velocity
nov_p  = max(max(elements(1:3,:))); %number of dof for pressure

[detjac,dcdx,dcdy,dedx,dedy]=mygeotrasf2D(nov,vertices,noe,elements);
[MASSA,DERXX,DERYY,DERXY,DERX,DERY]=matricesP22D;
%MASSAp=matricesP12D;
DERYX = DERXY';
[DIVX,DIVY]=matricesdivP2P12D;

% [DIVX2,DIVY2]=matricesdivP2P02D;
% keyboard
nln_p = 3;
nln_u =6;% 
l1 = [1:nln_u:(nln_u-1)*nln_u+1];
l2 = [nln_u:nln_u:nln_u*nln_u];
k = 1;
for i = 1:nln_u
    for j = 1:nln_p
        pl(i,j) = k;
        k = k + 1;
    end
end
gradgrad = [DERXX(:)'; DERYY(:)'; DERYX(:)'; DERXY(:)'];
clear DERXX DERYY DERXY DERX DERY
[u,diffusion,rho,p]=asseg_prop(vertices(1,:),vertices(2,:),noe,elements);


[matrix,M]=assemStokes(dcdx,dedx,dcdy,dedy,detjac,gradgrad,...
    vertices,elements,nln_u,nln_p,pl,nov,nov_v,nov_p,noe,DIVX,DIVY,...
    diffusion,rho,l1,l2,MASSA);

rhs = zeros(nov_v+nov_p,1);




%%%%%%%%%%%IMPOSING B.C.
DiriSideu2 = unique(find(boundaries(5,:)==2));
% DiriSidev2 = []; %per imporre T.n.n=0,  per imporre v=0
DiriSidev2 = unique(find(boundaries(5,:)==2));  % per imporre v=0,
DiriSideu1 = unique(find(boundaries(5,:)==1));%%%%%%%%%questa e' la riga diversa
DiriSidev1 = unique(find(boundaries(5,:)==1));
DiriSideT  = unique(find(boundaries(5,:)==11));
Dirichletu1= unique([boundaries(1,DiriSideu1),boundaries(2,DiriSideu1),boundaries(3,DiriSideu1)]);
Dirichletv1= unique([boundaries(1,DiriSidev1),boundaries(2,DiriSidev1),boundaries(3,DiriSidev1)]);
Dirichletu2= unique([boundaries(1,DiriSideu2),boundaries(2,DiriSideu2),boundaries(3,DiriSideu2)]);
Dirichletv2= unique([boundaries(1,DiriSidev2),boundaries(2,DiriSidev2),boundaries(3,DiriSidev2)]);
DirichletT = unique([boundaries(1,DiriSideT),boundaries(2,DiriSideT),boundaries(3,DiriSideT)]);



%%%%%%%% GET DIRICHLET BC VALUES %%%%%%%%%%%%%%%%%%%%%%%%%%
uDir1=0.0+0*vertices(1,Dirichletu1);
vDir1=0+0*vertices(1,Dirichletv1);
uDir2=0+0*vertices(1,Dirichletu2);
vDir2=0+0*vertices(1,Dirichletv2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% I impose strongly on one node the value of the pressure p0,
% i choose the node nov_v+10

p0=7.5555;  % pressure in one point

%%%%%%%% IMPOSE BOUNDARY CONDITIONS %%%%%%%%%%%%%%%%%%%%%
fprintf('Imposing Dirichlet BC''s...');                 %
allDir=unique([Dirichletu1    , Dirichletu2,...         %
    Dirichletv1+nov, Dirichletv2+nov,nov_v+10]);

tic
Isp=speye(size(matrix));                                %
matrix(allDir,:)=Isp(allDir,:); 
%%%%% FIXING TO ELIMINATE also the COLUMN on the matrix Gp
pbc=zeros(size(matrix,1),1);
pbc(nov_v+10)=1;
drh=p0*matrix(1:end,nov_v+10);
matrix(:,nov_v+10)=pbc;
matrix(:,allDir)=Isp(:,allDir); 
toc


x=vertices(1,:);
y=vertices(2,:);


f=@(x,y) -12*(x-1).^2.*(2*y-1).*x.^2-4*(6*x.^2-6*x+1).*y.*(2*y.^2-3*y+1)-10;
f2=@(x,y) 12*(2*x-1).*(y-1).^2.*y.^2+4*(6*y.^2-6*y+1).*x.*(2*x.^2-3*x+1)+5*y;
fx =feval(f,x,y);
fy =feval(f2,x,y);

%%%
% YOU HAVE TO IMPLEMENT HERE THE EXACT RHS
%%%



%%% IMPOSE DIRICHLET BCs ON rhs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rhs([Dirichletu1,Dirichletu2,Dirichletv1+nov,Dirichletv2+nov,nov_v+10]) = ... 
    [uDir1(:);uDir2(:);vDir1(:);vDir2(:);p0]; 

rhs(1:end,1)=rhs(1:end,1)-drh;
rhs(nov_v+10)=p0;
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fprintf('\nSolving the linear system... ');         %
u = matrix\rhs;                                     %
fprintf('done!\n');                                 %          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%UZAWA%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
velf=u(1:nov_v);
pres=u(nov_v+1:end);

A=matrix(1:nov_v,1:nov_v);
Gp=matrix(1:nov_v,nov_v+1:end);
Dp=matrix(nov_v+1:end,1:nov_v);

%% The mass matrix that you need to you for the time dependet problem is
%% called M.


